from django.contrib import admin
from .models import Project


@admin.register(Project)
class ProjectAdmin(admin.ModelAdmin):
    """
    Admin para modelo Project.
    """
    list_display = ['nome', 'portfolio', 'cliente', 'status', 'progresso', 'cronograma_fim', 'ativo']
    list_filter = ['ativo', 'status', 'prioridade', 'portfolio', 'cliente', 'created_at']
    search_fields = ['nome', 'descricao', 'portfolio__nome', 'cliente__nome']
    list_editable = ['ativo', 'status']
    ordering = ['portfolio__nome', 'cronograma_inicio']
    date_hierarchy = 'cronograma_inicio'
    
    fieldsets = (
        ('Informações Básicas', {
            'fields': ('nome', 'descricao', 'portfolio', 'workspace', 'cliente', 'ativo')
        }),
        ('Cronograma', {
            'fields': ('cronograma_inicio', 'cronograma_fim', 'status', 'prioridade')
        }),
        ('Orçamento', {
            'fields': ('orcamento', 'custo_real')
        }),
        ('Metadados', {
            'fields': ('created_at', 'updated_at'),
            'classes': ('collapse',)
        }),
    )
    
    readonly_fields = ['created_at', 'updated_at']
    
    def progresso(self, obj):
        return f"{obj.progresso}%"
    progresso.short_description = 'Progresso'
    
    def get_queryset(self, request):
        return super().get_queryset(request).select_related('portfolio', 'workspace', 'cliente')

