# Generated by Django 5.2.4 on 2025-07-17 23:15

import django.core.validators
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("client", "0001_initial"),
        ("portfolio", "0001_initial"),
        ("workspace", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Project",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "nome",
                    models.CharField(
                        help_text="Nome do projeto", max_length=200, verbose_name="Nome"
                    ),
                ),
                (
                    "descricao",
                    models.TextField(
                        blank=True,
                        help_text="Descrição detalhada do projeto",
                        null=True,
                        verbose_name="Descrição",
                    ),
                ),
                (
                    "cronograma_inicio",
                    models.DateField(
                        help_text="Data de início planejada do projeto",
                        verbose_name="Data de Início",
                    ),
                ),
                (
                    "cronograma_fim",
                    models.DateField(
                        help_text="Data de fim planejada do projeto",
                        verbose_name="Data de Fim",
                    ),
                ),
                (
                    "data_inicio_real",
                    models.DateField(
                        blank=True,
                        help_text="Data real de início do projeto",
                        null=True,
                        verbose_name="Data de Início Real",
                    ),
                ),
                (
                    "data_fim_real",
                    models.DateField(
                        blank=True,
                        help_text="Data real de conclusão do projeto",
                        null=True,
                        verbose_name="Data de Fim Real",
                    ),
                ),
                (
                    "progresso",
                    models.IntegerField(
                        default=0,
                        help_text="Percentual de progresso do projeto (0-100)",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(100),
                        ],
                        verbose_name="Progresso (%)",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("planejamento", "Planejamento"),
                            ("em_andamento", "Em Andamento"),
                            ("pausado", "Pausado"),
                            ("concluido", "Concluído"),
                            ("cancelado", "Cancelado"),
                        ],
                        default="planejamento",
                        help_text="Status atual do projeto",
                        max_length=20,
                        verbose_name="Status",
                    ),
                ),
                (
                    "prioridade",
                    models.CharField(
                        choices=[
                            ("baixa", "Baixa"),
                            ("media", "Média"),
                            ("alta", "Alta"),
                            ("urgente", "Urgente"),
                        ],
                        default="media",
                        help_text="Prioridade do projeto",
                        max_length=10,
                        verbose_name="Prioridade",
                    ),
                ),
                (
                    "orcamento",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="Orçamento do projeto",
                        max_digits=12,
                        null=True,
                        verbose_name="Orçamento",
                    ),
                ),
                (
                    "custo_real",
                    models.DecimalField(
                        decimal_places=2,
                        default=0,
                        help_text="Custo real do projeto",
                        max_digits=12,
                        verbose_name="Custo Real",
                    ),
                ),
                (
                    "ativo",
                    models.BooleanField(
                        default=True,
                        help_text="Indica se o projeto está ativo",
                        verbose_name="Ativo",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Criado em"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Atualizado em"),
                ),
                (
                    "cliente",
                    models.ForeignKey(
                        help_text="Cliente proprietário do projeto",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="projects",
                        to="client.client",
                        verbose_name="Cliente",
                    ),
                ),
                (
                    "portfolio",
                    models.ForeignKey(
                        help_text="Portfolio ao qual o projeto pertence",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="projects",
                        to="portfolio.portfolio",
                        verbose_name="Portfolio",
                    ),
                ),
                (
                    "workspace",
                    models.ForeignKey(
                        help_text="Workspace ao qual o projeto pertence",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="projects",
                        to="workspace.workspace",
                        verbose_name="Workspace",
                    ),
                ),
            ],
            options={
                "verbose_name": "Projeto",
                "verbose_name_plural": "Projetos",
                "ordering": ["portfolio", "nome"],
                "unique_together": {("portfolio", "nome")},
            },
        ),
    ]
