from django.db.models.signals import post_save
from django.dispatch import receiver
from .models import Project


@receiver(post_save, sender=Project)
def project_post_save(sender, instance, **kwargs):
    """
    Signal executado após salvar um projeto.
    """
    # Recalcular estatísticas do portfolio
    if instance.portfolio:
        instance.portfolio.save()


# Importar signals no apps.py
def ready():
    import project.signals

