from django.urls import path
from . import views

app_name = 'project'

urlpatterns = [
    path('', views.project_list, name='list'),
    path('create/', views.project_create, name='create'),
    path('create-modal/', views.ProjectCreateModalView.as_view(), name='create_modal'),
    path('<int:pk>/', views.project_detail, name='detail'),
    path('<int:pk>/edit-modal/', views.ProjectUpdateModalView.as_view(), name='edit_modal'),
    path('<int:pk>/edit/', views.project_edit, name='edit'),
    path('<int:pk>/delete/', views.project_delete, name='delete'),
]
