#!/bin/bash

# Script de inicialização do Sistema de Gestão de Agência
echo "============================================================"
echo "SISTEMA DE GESTÃO DE AGÊNCIA"
echo "============================================================"

# Verificar se o ambiente virtual existe
if [ ! -d "venv" ]; then
    echo "❌ Ambiente virtual não encontrado!"
    echo "Execute: python3 -m venv venv"
    exit 1
fi

# Ativar ambiente virtual
echo "🔧 Ativando ambiente virtual..."
source venv/bin/activate

# Verificar se as dependências estão instaladas
if ! python -c "import django" 2>/dev/null; then
    echo "❌ Django não encontrado!"
    echo "Execute: pip install -r requirements.txt"
    exit 1
fi

# Verificar se o banco de dados existe
if [ ! -f "db.sqlite3" ]; then
    echo "❌ Banco de dados não encontrado!"
    echo "Execute: python manage.py migrate"
    exit 1
fi

echo "✅ Sistema pronto!"
echo ""
echo "🚀 Iniciando servidor Django..."
echo "📱 Acesse: http://localhost:8000"
echo "🔐 Admin: http://localhost:8000/admin"
echo ""
echo "👥 Usuários de exemplo:"
echo "   Admin: admin / admin123"
echo "   Gerente: gerente / 123456"
echo "   Colaboradores: ana.dev, carlos.design, etc. / 123456"
echo ""
echo "⏹️  Para parar o servidor, pressione Ctrl+C"
echo ""

# Iniciar servidor
python manage.py runserver 