#!/bin/bash

# Script de inicialização para Cloudez
# Baseado na documentação: https://help.cloudez.io/subir-aplicacao-customizada-em-python/

# Ativa o ambiente virtual Python da Cloudez
source /srv/gestao.blackbeans.com.br/.virtualenv/3.7/bin/activate

# Define variáveis de ambiente
export DJANGO_SETTINGS_MODULE=gestao_agencia.settings
export PYTHONPATH=/srv/gestao.blackbeans.com.br/www

# Navega para o diretório da aplicação
cd /srv/gestao.blackbeans.com.br/www

# Executa migrações se necessário
python manage.py migrate --noinput

# Coleta arquivos estáticos
python manage.py collectstatic --noinput

# Inicia a aplicação Django com Gunicorn
exec /srv/gestao.blackbeans.com.br/.virtualenv/3.7/bin/gunicorn \
    --bind 0.0.0.0:$PORT \
    --workers 4 \
    --timeout 120 \
    --access-logfile - \
    --error-logfile - \
    gestao_agencia.wsgi:application 