/**
 * Script de Debug para Tarefas
 * Use no console do navegador para verificar o status de uma tarefa
 */

function debugTarefa(taskId) {
    console.log(`🔍 Debugando tarefa ${taskId}...`);
    
    fetch(`/tasks/${taskId}/debug/`, {
        method: 'GET',
        headers: {
            'X-CSRFToken': getCookie('csrftoken'),
        }
    })
    .then(response => response.json())
    .then(data => {
        console.log('📊 Informações da Tarefa:', data);
        
        console.log('🔍 Análise:');
        console.log(`- Status: ${data.status} (${data.status_display})`);
        console.log(`- Está trabalhando: ${data.esta_trabalhando}`);
        console.log(`- Pode iniciar: ${data.pode_iniciar}`);
        console.log(`- Responsável: ${data.responsavel || 'Nenhum'}`);
        console.log(`- Usuário atual: ${data.user_atual}`);
        console.log(`- É responsável: ${data.user_is_responsavel}`);
        
        if (data.tempo_iniciado) {
            console.log(`- Tempo iniciado: ${data.tempo_iniciado}`);
        }
        if (data.tempo_pausado) {
            console.log(`- Tempo pausado: ${data.tempo_pausado}`);
        }
        
        console.log(`- Tempo total: ${data.tempo_total_formatado}`);
        console.log(`- Tempo hoje: ${data.tempo_hoje_formatado}`);
        console.log(`- Esforço utilizado: ${data.esforco_utilizado}h`);
        
        // Sugestões
        console.log('\n💡 Sugestões:');
        if (!data.user_is_responsavel) {
            console.log('- ❌ Você não é o responsável por esta tarefa');
        } else if (data.status === 'concluida') {
            console.log('- ❌ Tarefa já está concluída');
        } else if (data.status === 'cancelada') {
            console.log('- ❌ Tarefa está cancelada');
        } else if (data.esta_trabalhando) {
            console.log('- ⏸️ Tarefa já está sendo trabalhada (use pausar)');
        } else if (data.status === 'pausada') {
            console.log('- ▶️ Tarefa está pausada (use retomar)');
        } else if (data.status === 'em_andamento') {
            console.log('- ▶️ Tarefa está em andamento mas não ativa (pode iniciar)');
        } else if (data.status === 'nao_iniciada') {
            console.log('- ▶️ Tarefa não iniciada (pode iniciar)');
        }
        
    })
    .catch(error => {
        console.error('❌ Erro ao debugar tarefa:', error);
    });
}

function testarIniciarTarefa(taskId) {
    console.log(`🧪 Testando iniciar tarefa ${taskId}...`);
    
    fetch(`/tasks/${taskId}/iniciar/`, {
        method: 'POST',
        headers: {
            'X-CSRFToken': getCookie('csrftoken'),
            'Content-Type': 'application/json',
        }
    })
    .then(response => response.json())
    .then(data => {
        console.log('📤 Resposta:', data);
        if (data.success) {
            console.log('✅ Sucesso!');
        } else {
            console.log('❌ Erro:', data.message);
        }
    })
    .catch(error => {
        console.error('❌ Erro na requisição:', error);
    });
}

function getCookie(name) {
    let cookieValue = null;
    if (document.cookie && document.cookie !== '') {
        const cookies = document.cookie.split(';');
        for (let i = 0; i < cookies.length; i++) {
            const cookie = cookies[i].trim();
            if (cookie.substring(0, name.length + 1) === (name + '=')) {
                cookieValue = decodeURIComponent(cookie.substring(name.length + 1));
                break;
            }
        }
    }
    return cookieValue;
}

// Função para debug da tarefa atual (se estiver na página de detalhes)
function debugTarefaAtual() {
    const url = window.location.pathname;
    const match = url.match(/\/tasks\/(\d+)\//);
    if (match) {
        const taskId = match[1];
        debugTarefa(taskId);
    } else {
        console.log('❌ Não foi possível identificar o ID da tarefa na URL');
        console.log('URL atual:', url);
    }
}

// Auto-executar se estiver na página de detalhes da tarefa
if (window.location.pathname.includes('/tasks/') && window.location.pathname.match(/\/tasks\/\d+\/$/)) {
    console.log('🔧 Script de debug carregado!');
    console.log('Use debugTarefaAtual() para verificar a tarefa atual');
    console.log('Use debugTarefa(ID) para verificar uma tarefa específica');
    console.log('Use testarIniciarTarefa(ID) para testar iniciar uma tarefa');
} 