# Generated by Django 5.2.4 on 2025-07-25 20:36

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="SystemLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "timestamp",
                    models.DateTimeField(auto_now_add=True, verbose_name="Data/Hora"),
                ),
                (
                    "action",
                    models.CharField(
                        choices=[
                            ("CREATE", "Criar"),
                            ("UPDATE", "Atualizar"),
                            ("DELETE", "Excluir"),
                            ("LOGIN", "Login"),
                            ("LOGOUT", "Logout"),
                            ("VIEW", "Visualizar"),
                            ("DOWNLOAD", "Download"),
                            ("UPLOAD", "Upload"),
                            ("EXPORT", "Exportar"),
                            ("IMPORT", "Importar"),
                            ("PERMISSION_CHANGE", "Alteração de Permissão"),
                            ("SYSTEM_CONFIG", "Configuração do Sistema"),
                            ("ERROR", "Erro"),
                            ("WARNING", "Aviso"),
                            ("INFO", "Informação"),
                        ],
                        max_length=50,
                        verbose_name="Ação",
                    ),
                ),
                (
                    "severity",
                    models.CharField(
                        choices=[
                            ("LOW", "Baixo"),
                            ("MEDIUM", "Médio"),
                            ("HIGH", "Alto"),
                            ("CRITICAL", "Crítico"),
                        ],
                        default="MEDIUM",
                        max_length=20,
                        verbose_name="Severidade",
                    ),
                ),
                (
                    "object_id",
                    models.PositiveIntegerField(
                        blank=True, null=True, verbose_name="ID do Objeto"
                    ),
                ),
                ("description", models.TextField(verbose_name="Descrição")),
                (
                    "details",
                    models.JSONField(
                        blank=True, null=True, verbose_name="Detalhes Adicionais"
                    ),
                ),
                (
                    "ip_address",
                    models.GenericIPAddressField(
                        blank=True, null=True, verbose_name="Endereço IP"
                    ),
                ),
                (
                    "user_agent",
                    models.TextField(blank=True, null=True, verbose_name="User Agent"),
                ),
                (
                    "session_id",
                    models.CharField(
                        blank=True,
                        max_length=100,
                        null=True,
                        verbose_name="ID da Sessão",
                    ),
                ),
                (
                    "url",
                    models.URLField(
                        blank=True, max_length=500, null=True, verbose_name="URL"
                    ),
                ),
                (
                    "method",
                    models.CharField(
                        blank=True, max_length=10, null=True, verbose_name="Método HTTP"
                    ),
                ),
                (
                    "content_type",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                        verbose_name="Tipo de Conteúdo",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Usuário",
                    ),
                ),
            ],
            options={
                "verbose_name": "Log do Sistema",
                "verbose_name_plural": "Logs do Sistema",
                "ordering": ["-timestamp"],
                "indexes": [
                    models.Index(
                        fields=["timestamp"], name="system_logs_timesta_85ede5_idx"
                    ),
                    models.Index(
                        fields=["user"], name="system_logs_user_id_b1c800_idx"
                    ),
                    models.Index(
                        fields=["action"], name="system_logs_action_5b1386_idx"
                    ),
                    models.Index(
                        fields=["severity"], name="system_logs_severit_20defb_idx"
                    ),
                    models.Index(
                        fields=["content_type", "object_id"],
                        name="system_logs_content_b88cee_idx",
                    ),
                ],
            },
        ),
    ]
