from django.contrib.auth.signals import user_logged_in, user_logged_out, user_login_failed
from django.dispatch import receiver
from django.contrib.auth.models import User
from .utils import log_user_login, log_user_logout


@receiver(user_logged_in)
def log_user_login_signal(sender, request, user, **kwargs):
    """Registra login bem-sucedido"""
    log_user_login(request, user, success=True)


@receiver(user_logged_out)
def log_user_logout_signal(sender, request, user, **kwargs):
    """Registra logout"""
    if user:
        log_user_logout(request, user)


@receiver(user_login_failed)
def log_user_login_failed_signal(sender, request, credentials, **kwargs):
    """Registra tentativa de login falhada"""
    username = credentials.get('username', 'unknown')
    
    # Cria um usuário temporário para o log
    temp_user = User()
    temp_user.username = username
    
    log_user_login(request, temp_user, success=False) 