from django.urls import path
from . import views

app_name = 'system_logs'

urlpatterns = [
    # Dashboard principal
    path('', views.log_dashboard, name='dashboard'),
    
    # Lista de logs
    path('list/', views.log_list, name='list'),
    
    # Detalhes de um log específico
    path('detail/<int:log_id>/', views.log_detail, name='detail'),
    
    # Views baseadas em classe (alternativas)
    path('logs/', views.SystemLogListView.as_view(), name='log_list_class'),
    path('logs/<int:pk>/', views.SystemLogDetailView.as_view(), name='log_detail_class'),
] 