# Generated by Django 5.2.4 on 2025-07-17 23:15

import datetime
import django.core.validators
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("board", "0001_initial"),
        ("collaborator", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Group",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "nome",
                    models.CharField(
                        help_text="Nome do grupo", max_length=200, verbose_name="Nome"
                    ),
                ),
                (
                    "descricao",
                    models.TextField(
                        blank=True,
                        help_text="Descrição do grupo",
                        null=True,
                        verbose_name="Descrição",
                    ),
                ),
                (
                    "cor",
                    models.CharField(
                        default="#6c757d",
                        help_text="Cor do grupo (formato hexadecimal)",
                        max_length=7,
                        verbose_name="Cor",
                    ),
                ),
                (
                    "ordem",
                    models.IntegerField(
                        default=0,
                        help_text="Ordem de exibição do grupo",
                        verbose_name="Ordem",
                    ),
                ),
                (
                    "ativo",
                    models.BooleanField(
                        default=True,
                        help_text="Indica se o grupo está ativo",
                        verbose_name="Ativo",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Criado em"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Atualizado em"),
                ),
                (
                    "board",
                    models.ForeignKey(
                        help_text="Quadro ao qual o grupo pertence",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="groups",
                        to="board.board",
                        verbose_name="Quadro",
                    ),
                ),
            ],
            options={
                "verbose_name": "Grupo",
                "verbose_name_plural": "Grupos",
                "ordering": ["board", "ordem", "nome"],
                "unique_together": {("board", "nome")},
            },
        ),
        migrations.CreateModel(
            name="Task",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "nome",
                    models.CharField(
                        help_text="Nome da tarefa", max_length=200, verbose_name="Nome"
                    ),
                ),
                (
                    "descricao",
                    models.TextField(
                        blank=True,
                        help_text="Descrição detalhada da tarefa",
                        null=True,
                        verbose_name="Descrição",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("nao_iniciada", "Não Iniciada"),
                            ("em_andamento", "Em Andamento"),
                            ("pausada", "Pausada"),
                            ("concluida", "Concluída"),
                            ("cancelada", "Cancelada"),
                        ],
                        default="nao_iniciada",
                        help_text="Status atual da tarefa",
                        max_length=20,
                        verbose_name="Status",
                    ),
                ),
                (
                    "prioridade",
                    models.CharField(
                        choices=[
                            ("baixa", "Baixa"),
                            ("media", "Média"),
                            ("alta", "Alta"),
                        ],
                        default="media",
                        help_text="Prioridade da tarefa",
                        max_length=10,
                        verbose_name="Prioridade",
                    ),
                ),
                (
                    "cronograma_inicio",
                    models.DateField(
                        help_text="Data de início planejada da tarefa",
                        verbose_name="Data de Início",
                    ),
                ),
                (
                    "cronograma_fim",
                    models.DateField(
                        help_text="Data de fim planejada da tarefa",
                        verbose_name="Data de Fim",
                    ),
                ),
                (
                    "duracao_dias",
                    models.IntegerField(
                        help_text="Duração da tarefa em dias úteis",
                        validators=[django.core.validators.MinValueValidator(1)],
                        verbose_name="Duração (dias)",
                    ),
                ),
                (
                    "esforco_previsto",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Esforço previsto em horas",
                        max_digits=6,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="Esforço Previsto (horas)",
                    ),
                ),
                (
                    "esforco_utilizado",
                    models.DecimalField(
                        decimal_places=2,
                        default=0,
                        help_text="Esforço já utilizado em horas",
                        max_digits=6,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="Esforço Utilizado (horas)",
                    ),
                ),
                (
                    "data_conclusao",
                    models.DateTimeField(
                        blank=True,
                        help_text="Data e hora de conclusão da tarefa",
                        null=True,
                        verbose_name="Data de Conclusão",
                    ),
                ),
                (
                    "tempo_iniciado",
                    models.DateTimeField(
                        blank=True,
                        help_text="Timestamp do último início de trabalho",
                        null=True,
                        verbose_name="Tempo Iniciado",
                    ),
                ),
                (
                    "tempo_pausado",
                    models.DateTimeField(
                        blank=True,
                        help_text="Timestamp da última pausa",
                        null=True,
                        verbose_name="Tempo Pausado",
                    ),
                ),
                (
                    "tempo_total_trabalhado",
                    models.DurationField(
                        default=datetime.timedelta(0),
                        help_text="Tempo total trabalhado na tarefa",
                        verbose_name="Tempo Total Trabalhado",
                    ),
                ),
                (
                    "inserted_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Inserido em"),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Criado em"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Atualizado em"),
                ),
                (
                    "dependencias",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Tarefas das quais esta tarefa depende",
                        related_name="dependentes",
                        to="task.task",
                        verbose_name="Dependências",
                    ),
                ),
                (
                    "group",
                    models.ForeignKey(
                        help_text="Grupo ao qual a tarefa pertence",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="tasks",
                        to="task.group",
                        verbose_name="Grupo",
                    ),
                ),
                (
                    "responsavel",
                    models.ForeignKey(
                        blank=True,
                        help_text="Colaborador responsável pela tarefa",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="tasks",
                        to="collaborator.collaborator",
                        verbose_name="Responsável",
                    ),
                ),
            ],
            options={
                "verbose_name": "Tarefa",
                "verbose_name_plural": "Tarefas",
                "ordering": ["group", "cronograma_inicio", "nome"],
            },
        ),
    ]
