# Generated by Django 5.2.4 on 2025-07-18 18:35

import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("task", "0001_initial"),
    ]

    operations = [
        migrations.AddField(
            model_name="group",
            name="data_fim_prevista",
            field=models.DateField(
                blank=True,
                help_text="Data de fim prevista do grupo",
                null=True,
                verbose_name="Data de Fim Prevista",
            ),
        ),
        migrations.AddField(
            model_name="group",
            name="data_fim_real",
            field=models.DateField(
                blank=True,
                help_text="Data real de fim do grupo",
                null=True,
                verbose_name="Data de Fim Real",
            ),
        ),
        migrations.AddField(
            model_name="group",
            name="data_inicio_prevista",
            field=models.DateField(
                blank=True,
                help_text="Data de início prevista do grupo",
                null=True,
                verbose_name="Data de Início Prevista",
            ),
        ),
        migrations.AddField(
            model_name="group",
            name="data_inicio_real",
            field=models.DateField(
                blank=True,
                help_text="Data real de início do grupo",
                null=True,
                verbose_name="Data de Início Real",
            ),
        ),
        migrations.AddField(
            model_name="group",
            name="limite_tarefas",
            field=models.IntegerField(
                blank=True,
                help_text="Número máximo de tarefas permitidas no grupo (WIP limit)",
                null=True,
                verbose_name="Limite de Tarefas",
            ),
        ),
        migrations.AddField(
            model_name="group",
            name="tempo_estimado_total",
            field=models.DecimalField(
                decimal_places=2,
                default=0,
                help_text="Soma do tempo estimado de todas as tarefas",
                max_digits=8,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Tempo Estimado Total (horas)",
            ),
        ),
        migrations.AddField(
            model_name="group",
            name="tempo_utilizado_total",
            field=models.DecimalField(
                decimal_places=2,
                default=0,
                help_text="Soma do tempo utilizado de todas as tarefas",
                max_digits=8,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Tempo Utilizado Total (horas)",
            ),
        ),
        migrations.AddField(
            model_name="group",
            name="tipo",
            field=models.CharField(
                choices=[
                    ("backlog", "Backlog"),
                    ("planejamento", "Planejamento"),
                    ("desenvolvimento", "Desenvolvimento"),
                    ("teste", "Teste"),
                    ("revisao", "Revisão"),
                    ("producao", "Produção"),
                    ("concluido", "Concluído"),
                    ("arquivado", "Arquivado"),
                ],
                default="desenvolvimento",
                help_text="Tipo do grupo (define o fluxo de trabalho)",
                max_length=20,
                verbose_name="Tipo",
            ),
        ),
    ]
