from django.urls import path
from . import views

app_name = 'task'

urlpatterns = [
    path('', views.task_list, name='list'),
    path('create/', views.task_create, name='create'),
    path('create-modal/', views.TaskCreateModalView.as_view(), name='create_modal'),
    path('create-group-modal/', views.GroupCreateModalView.as_view(), name='create_group_modal'),
    path('<int:pk>/', views.task_detail, name='detail'),
    path('<int:pk>/edit-modal/', views.TaskUpdateModalView.as_view(), name='edit_modal'),
    path('<int:pk>/edit/', views.task_edit, name='edit'),
    path('<int:pk>/delete/', views.task_delete, name='delete'),
    path('<int:pk>/iniciar/', views.iniciar_tarefa, name='iniciar'),
    path('<int:pk>/pausar/', views.pausar_tarefa, name='pausar'),
    path('<int:pk>/retomar/', views.retomar_tarefa, name='retomar'),

    path('<int:pk>/concluir/', views.concluir_tarefa, name='concluir'),
    path('<int:pk>/reset/', views.reset_tarefa, name='reset'),
    path('<int:pk>/tempo/', views.obter_tempo_tarefa, name='obter_tempo'),
    path('<int:pk>/debug/', views.debug_tarefa, name='debug'),
    
    # URLs para logs de sessões
    path('<int:pk>/logs/', views.obter_logs_sessoes, name='logs'),
    path('<int:pk>/editar_log/', views.editar_log_sessao, name='editar_log'),
    path('<int:pk>/deletar_log/', views.deletar_log_sessao, name='deletar_log'),
    
    path('my-tasks/', views.my_tasks, name='my_tasks'),
]
