#!/bin/bash

echo "============================================================"
echo "🧪 TESTE RÁPIDO DO SISTEMA - GESTÃO DE AGÊNCIA"
echo "============================================================"

# Ativar ambiente virtual
echo "🔧 Ativando ambiente virtual..."
source venv/bin/activate

# Verificar se Django está funcionando
echo "✅ Verificando Django..."
python manage.py check

# Verificar se o banco existe
if [ ! -f "db.sqlite3" ]; then
    echo "🗄️ Configurando banco de dados..."
    python setup.py
else
    echo "✅ Banco de dados já configurado"
fi

# Coletar arquivos estáticos
echo "📦 Coletando arquivos estáticos..."
python manage.py collectstatic --noinput

# Verificar configurações de produção
echo "🔍 Verificando configurações..."
python manage.py check --deploy

echo ""
echo "============================================================"
echo "🚀 INICIANDO SERVIDOR..."
echo "============================================================"
echo ""
echo "📱 Acesse: http://localhost:8000"
echo "🔐 Admin: http://localhost:8000/admin"
echo "👤 Login: admin / admin123"
echo ""
echo "⏹️  Para parar: Ctrl+C"
echo ""

# Iniciar servidor
python manage.py runserver 