from django.contrib import admin
from .models import Workspace


@admin.register(Workspace)
class WorkspaceAdmin(admin.ModelAdmin):
    """
    Admin para modelo Workspace.
    """
    list_display = ['nome', 'cliente', 'cor', 'ativo', 'created_at']
    list_filter = ['ativo', 'cliente', 'created_at']
    search_fields = ['nome', 'descricao', 'cliente__nome']
    list_editable = ['ativo']
    ordering = ['cliente__nome', 'nome']
    
    fieldsets = (
        ('Informações Básicas', {
            'fields': ('nome', 'descricao', 'cliente', 'cor', 'ativo')
        }),
        ('Metadados', {
            'fields': ('created_at', 'updated_at'),
            'classes': ('collapse',)
        }),
    )
    
    readonly_fields = ['created_at', 'updated_at']
    
    def get_queryset(self, request):
        return super().get_queryset(request).select_related('cliente')

