from django import forms
from .models import Workspace
from client.models import Client


class WorkspaceForm(forms.ModelForm):
    """
    Formulário para criação e edição de workspaces.
    """
    
    class Meta:
        model = Workspace
        fields = ['nome', 'descricao', 'cliente', 'cor', 'ativo']
        widgets = {
            'nome': forms.TextInput(attrs={
                'class': 'form-control',
                'placeholder': 'Nome do workspace'
            }),
            'descricao': forms.Textarea(attrs={
                'class': 'form-control',
                'rows': 3,
                'placeholder': 'Descrição do workspace'
            }),
            'cliente': forms.Select(attrs={
                'class': 'form-select'
            }),
            'cor': forms.TextInput(attrs={
                'class': 'form-control',
                'type': 'color',
                'placeholder': '#007bff'
            }),
            'ativo': forms.CheckboxInput(attrs={
                'class': 'form-check-input'
            })
        }
    
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        
        # Filtrar apenas clientes ativos
        self.fields['cliente'].queryset = Client.objects.filter(ativo=True).order_by('nome')
        
        # Adiciona classes CSS aos labels
        for field_name, field in self.fields.items():
            if field_name not in ['ativo', 'cor']:
                field.widget.attrs.update({'class': field.widget.attrs.get('class', '') + ' form-control'}) 