# Generated by Django 5.2.4 on 2025-07-17 23:15

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("client", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Workspace",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "nome",
                    models.CharField(
                        help_text="Nome do workspace",
                        max_length=200,
                        verbose_name="Nome",
                    ),
                ),
                (
                    "descricao",
                    models.TextField(
                        blank=True,
                        help_text="Descrição do workspace",
                        null=True,
                        verbose_name="Descrição",
                    ),
                ),
                (
                    "cor",
                    models.CharField(
                        default="#007bff",
                        help_text="Cor do workspace (formato hexadecimal)",
                        max_length=7,
                        verbose_name="Cor",
                    ),
                ),
                (
                    "ativo",
                    models.BooleanField(
                        default=True,
                        help_text="Indica se o workspace está ativo",
                        verbose_name="Ativo",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Criado em"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Atualizado em"),
                ),
                (
                    "cliente",
                    models.ForeignKey(
                        help_text="Cliente proprietário do workspace",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="workspaces",
                        to="client.client",
                        verbose_name="Cliente",
                    ),
                ),
            ],
            options={
                "verbose_name": "Workspace",
                "verbose_name_plural": "Workspaces",
                "ordering": ["cliente__nome", "nome"],
                "unique_together": {("cliente", "nome")},
            },
        ),
    ]
