from django.urls import path
from . import views

app_name = 'workspace'

urlpatterns = [
    path('', views.workspace_list, name='list'),
    path('create/', views.workspace_create, name='create'),
    path('create-modal/', views.WorkspaceCreateModalView.as_view(), name='create_modal'),
    path('<int:pk>/', views.workspace_detail, name='detail'),
    path('<int:pk>/edit/', views.workspace_edit, name='edit'),
    path('<int:pk>/edit-modal/', views.WorkspaceUpdateModalView.as_view(), name='edit_modal'),
    path('<int:pk>/delete/', views.workspace_delete, name='delete'),
]

